within ;
model J1_Dymola_ME
  Modelica.Blocks.Sources.Step step(height=1, startTime=1)
    annotation (Placement(transformation(extent={{-80,-10},{-60,10}})));
  Modelica.Mechanics.Rotational.Components.Inertia inertia(J=1)
    annotation (Placement(transformation(extent={{0,-10},{20,10}})));
  Modelica.Mechanics.Rotational.Sources.Torque torque
    annotation (Placement(transformation(extent={{-40,-10},{-20,10}})));
  Modelica.Mechanics.Rotational.Sources.Torque torque1
    annotation (Placement(transformation(extent={{60,-10},{40,10}})));
  Modelica.Blocks.Interfaces.RealInput TqSD
    "Accelerating torque acting at flange (= -flange.tau)"
    annotation (Placement(transformation(extent={{120,30},{100,50}})));
  Modelica.Mechanics.Rotational.Sensors.SpeedSensor speedSensor
    annotation (Placement(transformation(extent={{40,-50},{60,-30}})));
  Modelica.Blocks.Interfaces.RealOutput Nj1
    "Absolute angular velocity of flange as output signal"
    annotation (Placement(transformation(extent={{100,-50},{120,-30}})));
equation
  connect(inertia.flange_a, torque.flange)
    annotation (Line(points={{0,0},{-20,0}}, color={0,0,0}));
  connect(torque.tau, step.y)
    annotation (Line(points={{-42,0},{-59,0}}, color={0,0,127}));
  connect(torque1.tau, TqSD) annotation (Line(points={{62,0},{86,0},{86,
          40},{110,40}}, color={0,0,127}));
  connect(speedSensor.flange, inertia.flange_b) annotation (Line(points={
          {40,-40},{30,-40},{30,0},{20,0}}, color={0,0,0}));
  connect(speedSensor.w, Nj1)
    annotation (Line(points={{61,-40},{110,-40}}, color={0,0,127}));
  connect(torque1.flange, inertia.flange_b)
    annotation (Line(points={{40,0},{20,0}}, color={0,0,0}));
  annotation (
    Icon(coordinateSystem(preserveAspectRatio=false), graphics={Rectangle(
          extent={{-100,100},{100,-100}},
          lineColor={28,108,200},
          fillColor={255,255,255},
          fillPattern=FillPattern.Solid), Text(
          extent={{-100,20},{100,-20}},
          lineColor={28,108,200},
          textString="J1")}),
    Diagram(coordinateSystem(preserveAspectRatio=false)),
    experiment(StopTime=10, Interval=0.001),
    uses(Modelica(version="3.2.2")));
end J1_Dymola_ME;
